% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryEngine.R
\name{fetch_data}
\alias{fetch_data}
\title{Fetch data from the CENTREannotDb databases}
\usage{
fetch_data(x, columns, entries, column_filter)
}
\arguments{
\item{x}{A \code{CENTREannotDb} object.}

\item{columns}{Columns to select (vector or string). Equivalent to X in
SELECT X.}

\item{entries}{Element ID to select (vector or sting). Equivalent to ID in
SELECT X FROM TABLE WHERE ID in Z. If entries or column_filter is missing
the program assumes the query is SELECT X FROM TABLE.}

\item{column_filter}{Column on which to apply filter. Equivalent to Z in
SELECT X FROM TABLE WHERE ID in Z. If entries or column_filter is missing the
program assumes the query is SELECT X FROM TABLE.}
}
\value{
data.frame with the queried data.
}
\description{
Main interface to fetch data from the CENTREannotation package databases
through the \code{CENTREannotDb} objects.
}
\examples{
ah <- AnnotationHub::AnnotationHub()
CENTREannotenhDb <- ah[["AH116731"]]
res <- fetch_data(CENTREannotenhDb,
    columns = c("enhancer_id", "start"),
    entries = c("EH38E1519134", "EH38E1519132"),
    column_filter = "enhancer_id"
)
}
\references{
Based on the internal query engine of \code{CompoundDb}
}
