% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{addTargetFullName}
\alias{addTargetFullName}
\title{Add Target Full Name information to data frame}
\usage{
addTargetFullName(data)
}
\arguments{
\item{data}{a data frame generated by a \code{select} query. This data frame can
have any number of columns, but \strong{must} contain a PROBEID column. This
will be used to match the Target Full Name.}
}
\value{
The input data frame with one additional column
called "TARGETFULLNAME".
}
\description{
Retrieve the Target Full Name for a given SeqId (or set of SeqIds) and
add that information to a data frame. The Target Full Name can be found
in an ADAT file and represents the full name of the protein target of a
primary SOMAmer reagent.

Note: You can retrieve a list of Target Full Name values for a given set of
SeqIds with \code{mget(seqids, SomaScanTARGETFULLNAME)}, where \code{seqids} is a
character vector of SeqIds. To retrieve a data frame of \emph{all} Target Full
Name values present in the package, use \code{toTable(SomaScanTARGETFULLNAME)}.
}
\examples{
seqs <- withr::with_seed(123, sample(keys(SomaScan.db), 5))
res <- select(SomaScan.db, keys = seqs, columns = "UNIPROT")
addTargetFullName(res)
}
