% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{keys,SomaDb-method}
\alias{keys,SomaDb-method}
\alias{keys}
\title{The \code{keys} method for SomaDb objects}
\usage{
\S4method{keys}{SomaDb}(x, keytype, ...)
}
\arguments{
\item{x}{the \code{AnnotationDb} object. But in practice this will mean an 
    object derived from an \code{AnnotationDb} object such as a \code{OrgDb} or 
    \code{ChipDb} object.}

\item{keytype}{the keytype that matches the keys used.  For the
    \code{select} methods, this is used to indicate the kind of ID being used
    with the keys argument. For the \code{keys} method this is used to
    indicate which kind of keys are desired from \code{keys}
  }

\item{...}{other arguments.  These include:
    \describe{
      \item{pattern:}{the pattern to match (used by keys)}
      \item{column:}{the column to search on. This is used by keys and is
	for when the thing you want to pattern match is different from
	the keytype, or when you want to simply want to get keys that
	have a value for the thing specified by the column argument.}
      \item{fuzzy:}{TRUE or FALSE value.  Use fuzzy matching? (this is
	used with pattern by the keys method)}
    }
  }
}
\value{
A character vector of all available database keys.
}
\description{
\code{keys} returns the full set of keys for the annotation
database. A database "key" is a unique value that identifies a single row
of the database. By default, \code{keys} will return a vector of all primary
database keys. The primary keys for \code{SomaScan.db} are the SomaLogic
sequence identifiers, also called \code{SeqIds}.

If the \code{keytype} argument is specified, \code{keys} will return the keys that are
available for that keytype, rather than the \code{SeqIds} (see examples).
}
\examples{
# Preview the primary database keys
keys(SomaScan.db) |> head()

# View a different type of database key, e.g. gene symbols
keys(SomaScan.db, keytype = "SYMBOL") |> head()
}
\author{
Amanda Hiser
}
