% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{keytypes,SomaDb-method}
\alias{keytypes,SomaDb-method}
\alias{keytypes}
\title{The \code{keytypes} method for SomaDb objects}
\usage{
\S4method{keytypes}{SomaDb}(x)
}
\arguments{
\item{x}{the \code{AnnotationDb} object. But in practice this will mean an 
    object derived from an \code{AnnotationDb} object such as a \code{OrgDb} or 
    \code{ChipDb} object.}
}
\value{
A character vector of all available database keytypes.
}
\description{
\code{keytypes} produces a vector of annotation categories that can
be used as input keys for the \verb{keytype=} argument of the \code{select}, \code{mapIds},
and \code{keys} methods. The keytype also informs the query of the format of the
search key. For example, when searching the database for annotations
corresponding to the gene "NOTCH3", the key "NOTCH3" has the keytype of
"SYMBOL". Specifying \code{keytype="SYMBOL"} ensures that the gene symbol is not
confused for a different identifier ("key") type.

The default keytype ("PROBEID"), corresponds to the SomaLogic \code{SeqId}. For
more information on database keys, see \code{?keys}.
}
\examples{
# Retrieve a full list of available keytypes
keytypes(SomaScan.db)

# Specify a keytype other than PROBEID for select
select(SomaScan.db, keys = "NOTCH3", keytype = "SYMBOL",
       columns = "PROBEID")
}
\author{
Amanda Hiser
}
