% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{select,SomaDb-method}
\alias{select,SomaDb-method}
\alias{select}
\title{The \code{select} method for \code{SomaDb} objects}
\usage{
\S4method{select}{SomaDb}(x, keys, columns, keytype, menu = NULL, match = FALSE, ...)
}
\arguments{
\item{x}{the \code{AnnotationDb} object. But in practice this will mean an 
    object derived from an \code{AnnotationDb} object such as a \code{OrgDb} or 
    \code{ChipDb} object.}

\item{keys}{the keys to select records for from the database.  All possible 
    keys are returned by using the \code{keys} method.}

\item{columns}{the columns or kinds of things that can be retrieved
    from the database.  As with \code{keys}, all possible columns are
    returned by using the \code{columns} method.}

\item{keytype}{the keytype that matches the keys used.  For the
    \code{select} methods, this is used to indicate the kind of ID being used
    with the keys argument. For the \code{keys} method this is used to
    indicate which kind of keys are desired from \code{keys}
  }

\item{menu}{a character string identifying a SomaScan menu
version (optional). Possible options include: \code{"5k"},\code{"7k"}, or \code{"11k"},
as well as the version numbers for those menus (\code{"v4.0"}, \code{"v4.1"}, or
\code{"v5.0"}, respectively). May only be used when \code{keytype = "PROBEID"}.
This argument will filter the keys to the specified menu and only return
data associated with analytes present in that menu. By default, all
annotations from all analytes are available.}

\item{match}{a logical (TRUE/FALSE). Must be used with the "SYMBOL",
"ALIAS", or "GENENAME" keytypes only. If true, the character string
provided for \code{keys} will be used as a search term. The string will be
used to match symbols that also start with that string (ex. a key of
"CASP1" will return annotations for both the CASP10 & CASP14 genes).}

\item{...}{
  Arguments passed on to \code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::select}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
A \code{data.frame} containing the retrieved annotations.
}
\description{
\code{select} is the primary data retrieval method for the \code{SomaScan.db}
database. \code{select} will retrieve a data frame of SomaScan annotations based
on the parameters provided by the \code{keys}, \code{columns}, and \code{keytype}
arguments. The default keytype is "PROBEID", e.g. the SomaLogic \code{SeqId};
this value is used to tie all annotations back to a SomaScan-specific
identifier.
}
\details{
Users should be aware that if they call \code{select} and request columns that
have multiple matches for the provided keys (e.g. GO terms),
\code{select} will return a \code{data.frame} with one row \emph{for each possible match}.
This can have a multiplicative effect and result in a large number of
returned values. In general, if a user needs to retrieve a column that has
a many-to-one relationship to the original keys, it is best to extract data
from that column in its own query.
}
\examples{
# Retrieve a set of example keys
keys <- head(keys(SomaScan.db))
keys

# Look up the gene symbol and gene type for all example keys
select(SomaScan.db, keys = keys, columns = c("SYMBOL", "GENETYPE"))

# Look up SomaScan SeqIds & proteins associated with a gene of interest
select(SomaScan.db, keys = "NOTCH3", keytype = "SYMBOL", 
      columns = c("PROBEID", "UNIPROT"))
}
\author{
Amanda Hiser
}
