% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{findGenesByName}
\alias{findGenesByName}
\title{Find GeneIDs for names}
\usage{
findGenesByName(name)
}
\arguments{
\item{name}{\code{vector} of gene names.}
}
\value{
\code{data.frame} with columns specified above.
}
\description{
Get internal gene representation for set of gene names. Function lookups
for provided values in Human Name, Mouse Name and Rat Name columns and
return following features for all found genes: GeneID (internal database
ID), MGI ID, Human Entrez ID, Mouse Entrez ID, Rat Entrez ID, Human gene
name, Mouse gene name and Rat gene name.
}
\details{
Could be used as an intermediate step for building Protein-Protein
interaction map from the list of Gene IDs returned in the first column.
Also, this function provides a useful sanity check, e.g. how many Gene
IDs correspond to the specific gene name or Entrez ID, which could be
specie-specific.
}
\examples{
# Find GeneIDs for names
t <- findGenesByName(c("Src", "Srcin1", "Fyn"))
}
\seealso{
Other {Lookup functions}: 
\code{\link{findGenesByEntrez}()}

Other {Gene functions}: 
\code{\link{findGeneByCompartmentPaperCnt}()},
\code{\link{findGeneByPaperCnt}()},
\code{\link{findGeneByPapers}()},
\code{\link{findGenesByEntrez}()},
\code{\link{getAllGenes4Compartment}()},
\code{\link{getGenes4Compartment}()},
\code{\link{getGenesByID}()}
}
\concept{{Gene functions}}
\concept{{Lookup functions}}
