% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{getGeneInfoByPapers}
\alias{getGeneInfoByPapers}
\title{Get gene information for set of genes mentioned by certain papers.}
\usage{
getGeneInfoByPapers(pmids, cnt = 1)
}
\arguments{
\item{pmids}{vector of PMIDs to search for genes}

\item{cnt}{minimal number of papers that mentioned gene}
}
\value{
\code{data.frame} with fields specified above.
}
\description{
Function lookup for specified PubMedIDs in the gene reference data and
return following features for genes referenced by requested papers at
least \code{cnt} times:
GeneID (internal database ID), Localisation (one of the following:
presynaptic, postsynaptic, synaptosome),
MGI (MGI ID), HumanEntrez (Human Entrez ID), MouseEntrez (Mouse Entrez ID),
HumanName (Human gene name), MouseName (Mouse gene name),
PaperPMID (PMID IDs for the publications where the genes were reported if
it is within \code{pmids} list),
Paper (papers where specific genes were reported in a format
FIRSTAUTHOR_YEAR), Year, SpeciesTaxID (specie the original experiment
was performed on), BrainRegion (Brain region where the specific genes
were identified, according to the paper)
}
\details{
This function then returns
following features for all found genes:
\itemize{
\item GeneID,
\item Localisation,
\item MGI,
\item HumanEntrez,
\item MouseEntrez,
\item HumanName,
\item MouseName,
\item PaperPMID,
\item Paper,
\item Year,
\item SpeciesTaxID,
\item BrainRegion
}
}
\examples{
res<- getAllGenes4Compartment(compartmentID = 1)
gnt<-getGeneInfoByIDs(res$GeneID)
pmids<-names(sort(table(gnt$PaperPMID))[1:5])
cntT <- getGeneInfoByPapers(pmids,cnt=3)
head(cntT)
}
\seealso{
Other {GeneInfo functions}: 
\code{\link{getGeneInfoByEntrez}()},
\code{\link{getGeneInfoByIDs}()},
\code{\link{getGeneInfoByName}()}
}
\concept{{GeneInfo functions}}
