% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_regions.R
\name{getGenes4BrainRegion}
\alias{getGenes4BrainRegion}
\title{Select genes from the list that found in brain region of
particular specie}
\usage{
getGenes4BrainRegion(ids, brainRegion, taxID)
}
\arguments{
\item{ids}{internal IDs for list of genes}

\item{brainRegion}{ID for the brain region of interest}

\item{taxID}{taxon ID specie tax ID}
}
\value{
data.frame with the following columns:
\itemize{
\item GeneID
\item Localisation
\item MGI
\item HumanEntrez
\item MouseEntrez
\item HumanName
\item MouseName
\item PMID
\item Paper
\item Year
\item SpeciesTaxID
\item BrainRegion
}
}
\description{
Select genes from your list annotated for specific brain region. Should
be used with \code{\link[=findGenesByEntrez]{findGenesByEntrez()}}  or
\code{\link[=findGenesByName]{findGenesByName()}} functions to obtain
list of internal IDs for your list of genes. Function lookups the
Gene table for specified localisation and returns main gene information
like internal Gene IDs, MGI ID, Human Entrez ID, Human Gene Name,
Mouse Entrez ID, Mouse Gene Name, PaperPMID, Localisation and BrainRegion.
}
\examples{
Genes <- getGenes4BrainRegion(c(1, 15, 156, 1500, 3000, 7000),
    brainRegion = "Striatum", taxID = 10090
) # 5 rows
}
\seealso{
Other {BrainRegion functions}: 
\code{\link{getAllGenes4BrainRegion}()},
\code{\link{getBrainRegions}()},
\code{\link{getPPIbyIDs4BrainRegion}()}

Other {BrainRegion Gene functions}: 
\code{\link{getAllGenes4BrainRegion}()}
}
\concept{{BrainRegion Gene functions}}
\concept{{BrainRegion functions}}
