% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutations.R
\name{getMutations4DiseaseByEntres}
\alias{getMutations4DiseaseByEntres}
\title{Get mutational information for Gene and Disease}
\usage{
getMutations4DiseaseByEntres(entrez, hdoid)
}
\arguments{
\item{entrez}{list of Entrez IDs for genes to select}

\item{hdoid}{disease HDOID to get mutational association.}
}
\value{
\code{data.frame} as described in
        \code{\link{getMutations4DiseaseByIDs}}.
}
\description{
Function looks up the information for particular set of Entrez IDs
and disease HDOID.
}
\examples{
hdoid<-'DOID:0060041'
entrez<-c("23859", "17754", "18673", "268566", "12293", "320840", "24012")
mdf<-getMutations4DiseaseByEntres(entrez, hdoid)
is.null(mdf)
}
\seealso{
findGenesByEntrez

Other {Mutation functions}: 
\code{\link{getMutations4DiseaseByIDs}()},
\code{\link{getMutations4DiseaseByName}()}
}
\concept{{Mutation functions}}
