% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutations.R
\name{getMutations4DiseaseByName}
\alias{getMutations4DiseaseByName}
\title{Get mutational information for Gene and Disease}
\usage{
getMutations4DiseaseByName(name, hdoid)
}
\arguments{
\item{name}{gene names to look for}

\item{hdoid}{disease HDOID to get mutational association.}
}
\value{
\code{data.frame} as described in
        \code{\link{getMutations4DiseaseByIDs}}.
}
\description{
Function lookups for provided values in Human Name, Mouse Name and
Rat Name columns, extract known mutations, filter requested HDOID and return
data.frame in the format described in
\code{\link{getMutations4DiseaseByIDs}}.
}
\examples{
hdoid<-'DOID:0060041'
name<-c("Dlg2", "Map1a", "Phb", "Gphn", "Cacna2d1", "Negr1", "Rgs7")
mdf<-getMutations4DiseaseByName(name, hdoid)
is.null(mdf)
}
\seealso{
findGenesByName

Other {Mutation functions}: 
\code{\link{getMutations4DiseaseByEntres}()},
\code{\link{getMutations4DiseaseByIDs}()}
}
\concept{{Mutation functions}}
