% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compartments.R
\name{getPPIbyIDs4Compartment}
\alias{getPPIbyIDs4Compartment}
\title{Prepare induced or limited network for compartment}
\usage{
getPPIbyIDs4Compartment(ids, compartmentID, type = c("limited", "induced"))
}
\arguments{
\item{ids}{internal gene IDs}

\item{compartmentID}{ID for specific compartment}

\item{type}{type of the PPI network should be either `induced` (for
all the PPIs for specific genes, including external genes) or
`limited` (for PPIs between the genes specified in the query).
Type could be shortened to recognizable minimum like 'ind'
or 'lim'.}
}
\value{
data.frame with interactors internal GeneID in columns A and B
}
\description{
Prepare PPI network for genes from your list annotated for
specific compartment. Should be used with findGenesByEntrez
or findGenesByName functions to obtain list of internal IDs
for your list of genes. Could be used with getAllGenes4Compartment
functions to obtain all genes belonging to respective compartment.
Function lookups the PPI table for gene IDs from the list and
returns “limited” or “induced” interactors GeneIDs from the
same compartment.
}
\examples{
ppi <- getPPIbyIDs4Compartment(c(1, 15, 156, 1500, 3000, 7000),
    compartmentID = 1, type = "induced"
) # 201 rows
}
\seealso{
Other {PPI functions}: 
\code{\link{getIGraphFromPPI}()},
\code{\link{getPPIbyEntrez}()},
\code{\link{getPPIbyIDs}()},
\code{\link{getPPIbyIDs4BrainRegion}()},
\code{\link{getPPIbyName}()},
\code{\link{getTableFromPPI}()}

Other {Compartment functions}: 
\code{\link{getAllGenes4Compartment}()},
\code{\link{getCompartments}()},
\code{\link{getGenes4Compartment}()}
}
\concept{{Compartment functions}}
\concept{{PPI functions}}
