% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiTables.R
\name{getTableFromPPI}
\alias{getTableFromPPI}
\title{Get table representation of the PPI.}
\usage{
getTableFromPPI(ppi)
}
\arguments{
\item{ppi}{PPI \code{data.frame} with columns A and B, obtained
from functions like \code{\link{getPPIbyName}}}
}
\value{
table with the following columns added for both
interactors (A and B):
\itemize{
\item{GeneID internal database ID}
\item{MGI MGI ID}
\item{HumanEntrez Human Entrez ID}
\item{MouseEntrez Mouse Entrez ID}
\item{HumanName Human gene name}
\item{MouseName Mouse gene name}
\item{RatEntrez Rat Entrez ID}
\item{Rat Name Rat gene name}
}
}
\description{
Combine information from PPI \code{data.frame} obtained with functions like
\code{\link{getPPIbyName}} or \code{\link{getPPIbyEntrez}} with information
about genes obtained from
\code{\link{getGenesByID}} to make  interpretable table representation.
}
\examples{
tbl <- getTableFromPPI(getPPIbyIDs(c(48, 585, 710), type = "limited"))
}
\seealso{
\code{\link[=getPPIbyName]{getPPIbyName()}},
\code{\link[=getPPIbyEntrez]{getPPIbyEntrez()}}
and \code{\link[=getPPIbyIDs]{getPPIbyIDs()}} to get
PPI \code{data.frame},
\code{\link[=getIGraphFromPPI]{getIGraphFromPPI()}} to
get igraph representation of the PPI \code{data.frame}.

Other {PPI functions}: 
\code{\link{getIGraphFromPPI}()},
\code{\link{getPPIbyEntrez}()},
\code{\link{getPPIbyIDs}()},
\code{\link{getPPIbyIDs4BrainRegion}()},
\code{\link{getPPIbyIDs4Compartment}()},
\code{\link{getPPIbyName}()}
}
\concept{{DF functions}}
\concept{{PPI functions}}
